/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.buffer;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.memory.ShuffleMemoryTracker;

public abstract class AbstractBuffer
implements OutBuffer {
    protected int refCount;
    protected boolean memoryTrack;

    public AbstractBuffer() {
        this.memoryTrack = false;
    }

    public AbstractBuffer(boolean memoryTrack) {
        this.memoryTrack = memoryTrack;
    }

    @Override
    public void setRefCount(int refCount) {
        this.refCount = refCount;
    }

    @Override
    public boolean isDisposable() {
        return this.refCount <= 0;
    }

    @Override
    public boolean isMemoryTracking() {
        return this.memoryTrack;
    }

    protected void requireMemory(long dataSize) {
        if (this.memoryTrack) {
            ShuffleMemoryTracker.getInstance().requireMemory(dataSize);
        }
    }

    protected void releaseMemory(long dataSize) {
        if (this.memoryTrack) {
            ShuffleMemoryTracker.getInstance().releaseMemory(dataSize);
        }
    }

    protected static abstract class AbstractBufferBuilder
    implements OutBuffer.BufferBuilder {
        protected int batchCount;
        protected boolean memoryTrack;

        protected AbstractBufferBuilder() {
        }

        @Override
        public void enableMemoryTrack() {
            this.memoryTrack = true;
        }
    }
}

