/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.buffer;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.HeapBuffer;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import java.io.Serializable;

public class PipeBuffer
implements Serializable {
    private final OutBuffer buffer;
    private final boolean isData;
    private final long batchId;
    private final int count;
    private final boolean isFinish;

    public PipeBuffer(byte[] buffer, long batchId, boolean isData) {
        this.buffer = new HeapBuffer(buffer, true);
        this.batchId = batchId;
        this.isData = isData;
        this.count = 0;
        this.isFinish = false;
    }

    public PipeBuffer(OutBuffer buffer, long batchId, boolean isData) {
        this.buffer = buffer;
        this.batchId = batchId;
        this.isData = isData;
        this.count = 0;
        this.isFinish = false;
    }

    public PipeBuffer(long batchId, int count, boolean isData, boolean isFinish) {
        this.buffer = null;
        this.batchId = batchId;
        this.isData = isData;
        this.count = count;
        this.isFinish = isFinish;
    }

    public OutBuffer getBuffer() {
        return this.buffer;
    }

    public int getBufferSize() {
        return this.buffer != null ? this.buffer.getBufferSize() : 0;
    }

    public boolean isData() {
        return this.isData;
    }

    public long getBatchId() {
        return this.batchId;
    }

    public int getCount() {
        return this.count;
    }

    public boolean isFinish() {
        return this.isFinish;
    }
}

