/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.buffer;

import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.PipeBuffer;
import com.antgroup.geaflow.shuffle.message.SliceId;

public class PipeFetcherBuffer {
    private final PipeBuffer buffer;
    private final SliceId sliceId;
    private final String streamName;
    private boolean moreAvailable;
    private int channelIndex;

    public PipeFetcherBuffer(PipeBuffer pipeBuffer, int channelIndex, boolean moreAvailable, SliceId sliceId, String streamName) {
        this.buffer = pipeBuffer;
        this.channelIndex = channelIndex;
        this.moreAvailable = moreAvailable;
        this.sliceId = sliceId;
        this.streamName = streamName;
    }

    public boolean moreAvailable() {
        return this.moreAvailable;
    }

    public void setMoreAvailable(boolean moreAvailable) {
        this.moreAvailable = moreAvailable;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    public SliceId getSliceId() {
        return this.sliceId;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public int getBufferSize() {
        if (this.buffer != null) {
            return this.buffer.getBuffer().getBufferSize();
        }
        return 0;
    }

    public OutBuffer getBuffer() {
        return this.buffer.getBuffer();
    }

    public boolean isBarrier() {
        return !this.buffer.isData();
    }

    public long getBatchId() {
        return this.buffer.getBatchId();
    }

    public int getBatchCount() {
        return this.buffer.getCount();
    }

    public boolean isFinish() {
        return this.buffer.isFinish();
    }
}

