/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.pipeline.channel;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class ChannelId
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long upperPart;
    private final long lowerPart;

    public ChannelId() {
        UUID uuid = UUID.randomUUID();
        this.upperPart = uuid.getMostSignificantBits();
        this.lowerPart = uuid.getLeastSignificantBits();
    }

    public ChannelId(long lowerPart, long upperPart) {
        this.upperPart = upperPart;
        this.lowerPart = lowerPart;
    }

    public void writeTo(ByteBuf buf) {
        buf.writeLong(this.lowerPart);
        buf.writeLong(this.upperPart);
    }

    public static ChannelId readFrom(ByteBuf buf) {
        long lower = buf.readLong();
        long upper = buf.readLong();
        return new ChannelId(lower, upper);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelId that = (ChannelId)o;
        return this.upperPart == that.upperPart && this.lowerPart == that.lowerPart;
    }

    public int hashCode() {
        return Objects.hash(this.upperPart, this.lowerPart);
    }
}

