/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.reader;

import com.antgroup.geaflow.common.metric.ShuffleReadMetrics;
import com.antgroup.geaflow.common.shuffle.DataExchangeMode;
import com.antgroup.geaflow.shuffle.api.reader.FetchContext;
import com.antgroup.geaflow.shuffle.api.reader.IReaderContext;
import com.antgroup.geaflow.shuffle.api.reader.IShuffleFetcher;
import com.antgroup.geaflow.shuffle.api.reader.IShuffleReader;
import com.antgroup.geaflow.shuffle.api.reader.ShuffleFetcherFactory;
import com.antgroup.geaflow.shuffle.message.FetchRequest;
import com.antgroup.geaflow.shuffle.message.PipelineEvent;
import com.antgroup.geaflow.shuffle.network.IConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineReader
implements IShuffleReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineReader.class);
    private final IConnectionManager connectionManager;
    private IReaderContext readerContext;
    private IShuffleFetcher shuffleFetcher;

    public PipelineReader(IConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public void init(IReaderContext context) {
        this.readerContext = context;
    }

    @Override
    public void fetch(FetchRequest req) {
        DataExchangeMode exchangeMode = req.getDescriptor().getExchangeMode();
        this.initShuffleFetcher(exchangeMode);
        this.shuffleFetcher.init(new FetchContext(req));
    }

    private void initShuffleFetcher(DataExchangeMode exchangeMode) {
        if (this.shuffleFetcher == null) {
            this.shuffleFetcher = ShuffleFetcherFactory.getShuffleFetcher(exchangeMode, this.connectionManager, this.readerContext.getConfig());
        }
    }

    @Override
    public boolean hasNext() {
        return this.shuffleFetcher.hasNext();
    }

    @Override
    public PipelineEvent next() {
        return this.shuffleFetcher.next();
    }

    @Override
    public ShuffleReadMetrics getShuffleReadMetrics() {
        return this.shuffleFetcher.getReadMetrics();
    }

    @Override
    public void close() {
        try {
            if (this.shuffleFetcher != null) {
                this.shuffleFetcher.close();
            }
        }
        catch (Exception e) {
            LOGGER.warn("close reader failed", (Throwable)e);
        }
    }

    @Override
    public DataExchangeMode getExchangeMode() {
        return DataExchangeMode.PIPELINE;
    }
}

