/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.api.writer;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.PipelineShard;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.PipelineSlice;
import com.antgroup.geaflow.shuffle.api.writer.IWriterContext;
import com.antgroup.geaflow.shuffle.api.writer.PipelineWriter;
import com.antgroup.geaflow.shuffle.api.writer.ShardBuffer;
import com.antgroup.geaflow.shuffle.memory.ShuffleDataManager;
import com.antgroup.geaflow.shuffle.message.PipelineBarrier;
import com.antgroup.geaflow.shuffle.message.SliceId;
import com.antgroup.geaflow.shuffle.message.WriterId;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineShardBuffer<T, R>
extends ShardBuffer<T, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineWriter.class);
    private OutputFlusher outputFlusher;
    private final AtomicReference<Throwable> throwable = new AtomicReference();

    @Override
    public void init(IWriterContext writerContext) {
        super.init(writerContext);
        this.initResultSlices(this.targetChannels);
        String threadName = "OutputFlusher-" + Thread.currentThread().getName();
        int flushTimeout = this.shuffleConfig.getFlushBufferTimeoutMs();
        this.outputFlusher = new OutputFlusher(threadName, flushTimeout);
        this.outputFlusher.start();
    }

    private void initResultSlices(int channels) {
        PipelineSlice[] slices = new PipelineSlice[channels];
        WriterId writerID = new WriterId(this.pipelineId, this.edgeId, this.taskIndex);
        for (int i = 0; i < channels; ++i) {
            slices[i] = new PipelineSlice(this.taskLogTag, new SliceId(writerID, i));
        }
        this.resultSlices = slices;
        ShuffleDataManager.getInstance().register(writerID, new PipelineShard(this.taskLogTag, slices));
    }

    @Override
    public void emit(long batchId, T value, boolean isRetract, int[] channels) throws IOException {
        this.checkError();
        super.emit(batchId, value, isRetract, channels);
    }

    @Override
    public Optional<R> finish(long batchId) throws IOException {
        this.checkError();
        for (int i = 0; i < this.buffers.size(); ++i) {
            OutBuffer.BufferBuilder bufferBuilder = (OutBuffer.BufferBuilder)this.buffers.get(i);
            if (bufferBuilder.getBufferSize() <= 0) continue;
            this.send(i, bufferBuilder.build(), batchId);
        }
        PipelineBarrier barrier = new PipelineBarrier(batchId, this.edgeId, this.taskIndex);
        this.notify(barrier);
        return Optional.empty();
    }

    public void flushAll() {
        PipelineSlice[] pipeSlices = this.resultSlices;
        boolean flushed = false;
        if (pipeSlices != null) {
            for (int i = 0; i < pipeSlices.length; ++i) {
                if (null == pipeSlices[i]) continue;
                pipeSlices[i].flush();
                flushed = true;
            }
        }
        if (!flushed) {
            LOGGER.warn("terminate flusher due to slices released");
            this.outputFlusher.terminate();
        }
    }

    @Override
    public void close() {
        if (this.outputFlusher != null) {
            this.outputFlusher.terminate();
        }
    }

    private void checkError() throws IOException {
        if (this.throwable.get() != null) {
            Throwable t = this.throwable.get();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new GeaflowRuntimeException(t);
        }
    }

    private class OutputFlusher
    extends Thread {
        private final long timeout;
        private volatile boolean running;

        OutputFlusher(String name, long timeout) {
            super(name);
            this.running = true;
            this.setDaemon(true);
            this.timeout = timeout;
            LOGGER.info("started {} with timeout:{}ms", (Object)name, (Object)timeout);
        }

        public void terminate() {
            if (this.running) {
                this.running = false;
                this.interrupt();
            }
        }

        @Override
        public void run() {
            block6: {
                try {
                    while (this.running) {
                        block5: {
                            try {
                                Thread.sleep(this.timeout);
                            }
                            catch (InterruptedException e) {
                                if (!this.running) break block5;
                                LOGGER.error("Interrupted", (Throwable)e);
                                throw e;
                            }
                        }
                        PipelineShardBuffer.this.flushAll();
                    }
                }
                catch (Throwable t) {
                    if (!PipelineShardBuffer.this.throwable.compareAndSet(null, t)) break block6;
                    LOGGER.error("flush failed", t);
                }
            }
        }
    }
}

