/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.config;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.ExecutionConfigKeys;
import com.antgroup.geaflow.common.shuffle.StorageLevel;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleConfig.class);
    private final int serverPort;
    private final String serverAddress;
    private final boolean threadCacheEnabled;
    private final int connectTimeoutMs;
    private final int fetchTimeoutMs;
    private final int serverBacklog;
    private final int serverThreads;
    private final int clientThreads;
    private final long maxSpillSizePerSlice;
    private final boolean memoryPoolEnable;
    private final int fetchQueueSize;
    private final int emitQueueSize;
    private final int emitBufferSize;
    private final int writeBufferSizeBytes;
    private final int flushBufferTimeoutMs;
    private final double cacheSpillThreshold;
    private final Configuration configuration;
    private boolean compressionEnabled;
    private static ShuffleConfig INSTANCE;

    private ShuffleConfig(Configuration config) {
        this.serverAddress = config.getString(ExecutionConfigKeys.NETTY_SERVER_HOST);
        this.serverPort = config.getInteger(ExecutionConfigKeys.NETTY_SERVER_PORT);
        this.threadCacheEnabled = config.getBoolean(ExecutionConfigKeys.NETTY_THREAD_CACHE_ENABLE);
        this.connectTimeoutMs = config.getInteger(ExecutionConfigKeys.NETTY_CONNECT_TIMEOUT_MS);
        this.fetchTimeoutMs = config.getInteger(ExecutionConfigKeys.SHUFFLE_FETCH_TIMEOUT_MS);
        this.maxSpillSizePerSlice = config.getLong(ExecutionConfigKeys.SHUFFLE_SLICE_MAX_SPILL_SIZE);
        this.serverBacklog = config.getInteger(ExecutionConfigKeys.NETTY_SERVER_BACKLOG);
        this.serverThreads = config.getInteger(ExecutionConfigKeys.NETTY_SERVER_THREADS_NUM);
        this.clientThreads = config.getInteger(ExecutionConfigKeys.NETTY_CLIENT_THREADS_NUM);
        this.memoryPoolEnable = config.getBoolean(ExecutionConfigKeys.SHUFFLE_MEMORY_POOL_ENABLE);
        this.fetchQueueSize = config.getInteger(ExecutionConfigKeys.SHUFFLE_FETCH_QUEUE_SIZE);
        this.emitQueueSize = config.getInteger(ExecutionConfigKeys.SHUFFLE_EMIT_QUEUE_SIZE);
        this.emitBufferSize = config.getInteger(ExecutionConfigKeys.SHUFFLE_EMIT_BUFFER_SIZE);
        this.writeBufferSizeBytes = config.getInteger(ExecutionConfigKeys.SHUFFLE_WRITE_BUFFER_SIZE_BYTES);
        this.flushBufferTimeoutMs = config.getInteger(ExecutionConfigKeys.SHUFFLE_FLUSH_BUFFER_TIMEOUT_MS);
        this.cacheSpillThreshold = config.getDouble(ExecutionConfigKeys.SHUFFLE_CACHE_SPILL_THRESHOLD);
        this.compressionEnabled = config.getBoolean(ExecutionConfigKeys.SHUFFLE_COMPRESSION_ENABLE);
        this.configuration = config;
        LOGGER.info("init shuffle config: {}", (Object)config);
    }

    public static synchronized ShuffleConfig getInstance(Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new ShuffleConfig(config);
        }
        return INSTANCE;
    }

    @VisibleForTesting
    public static synchronized void reset(Configuration config) {
        INSTANCE = new ShuffleConfig(config);
    }

    public static ShuffleConfig getInstance() {
        return INSTANCE;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public boolean isThreadCacheEnabled() {
        return this.threadCacheEnabled;
    }

    public int getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public int getServerConnectBacklog() {
        return this.serverBacklog;
    }

    public int getServerThreadsNum() {
        return this.serverThreads;
    }

    public int getClientNumThreads() {
        return this.clientThreads;
    }

    public int getReceiveBufferSize() {
        return this.configuration.getInteger(ExecutionConfigKeys.NETTY_RECEIVE_BUFFER_SIZE);
    }

    public int getSendBufferSize() {
        return this.configuration.getInteger(ExecutionConfigKeys.NETTY_SEND_BUFFER_SIZE);
    }

    public boolean preferDirectBuffer() {
        return this.configuration.getBoolean(ExecutionConfigKeys.NETTY_PREFER_DIRECT_BUFFER);
    }

    public boolean enableCustomFrameDecoder() {
        return this.configuration.getBoolean(ExecutionConfigKeys.NETTY_CUSTOM_FRAME_DECODER_ENABLE);
    }

    public int getConnectMaxRetries() {
        return this.configuration.getInteger(ExecutionConfigKeys.NETTY_CONNECT_MAX_RETRIES);
    }

    public int getConnectInitialBackoffMs() {
        return this.configuration.getInteger(ExecutionConfigKeys.NETTY_CONNECT_INITIAL_BACKOFF_MS);
    }

    public int getConnectMaxBackoffMs() {
        return this.configuration.getInteger(ExecutionConfigKeys.NETTY_CONNECT_MAX_BACKOFF_MS);
    }

    public boolean isMemoryPoolEnable() {
        return this.memoryPoolEnable;
    }

    public int getFetchQueueSize() {
        return this.fetchQueueSize;
    }

    public int getEmitQueueSize() {
        return this.emitQueueSize;
    }

    public int getEmitBufferSize() {
        return this.emitBufferSize;
    }

    public int getWriteBufferSizeBytes() {
        return this.writeBufferSizeBytes;
    }

    public int getFlushBufferTimeoutMs() {
        return this.flushBufferTimeoutMs;
    }

    public double getCacheSpillThreshold() {
        return this.cacheSpillThreshold;
    }

    public Configuration getConfig() {
        return this.configuration;
    }

    public static StorageLevel getShuffleStorageType(Configuration configuration) {
        String confVal = configuration.getString(ExecutionConfigKeys.SHUFFLE_STORAGE_TYPE);
        if (confVal != null) {
            return StorageLevel.valueOf((String)String.valueOf(confVal).toLowerCase());
        }
        return StorageLevel.disk;
    }

    public String toString() {
        return "ShuffleConfig{, connectTimeoutMs=" + this.connectTimeoutMs + ", fetchTimeoutMs=" + this.fetchTimeoutMs + ", serverBacklog=" + this.serverBacklog + ", serverThreads=" + this.serverThreads + ", clientThreads=" + this.clientThreads + ", maxSpillSizePerSliceMB=" + this.maxSpillSizePerSlice / 0x100000L + '}';
    }
}

