/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.message;

import com.antgroup.geaflow.common.shuffle.ShuffleAddress;
import com.antgroup.geaflow.shuffle.message.BaseSliceMeta;
import com.antgroup.geaflow.shuffle.message.SliceId;

public class PipelineSliceMeta
extends BaseSliceMeta {
    private final SliceId sliceId;
    private final ShuffleAddress shuffleAddress;

    public PipelineSliceMeta(int sourceIndex, int targetIndex, long pipelineId, int edgeId, ShuffleAddress address) {
        super(sourceIndex, targetIndex);
        this.batchId = -1L;
        this.sliceId = new SliceId(pipelineId, edgeId, sourceIndex, targetIndex);
        this.shuffleAddress = address;
        this.setEdgeId(edgeId);
    }

    public PipelineSliceMeta(SliceId sliceId, long batchId, ShuffleAddress address) {
        super(sliceId.getShardIndex(), sliceId.getSliceIndex());
        this.batchId = batchId;
        this.sliceId = sliceId;
        this.shuffleAddress = address;
        this.setEdgeId(sliceId.getEdgeId());
    }

    @Override
    public long getBatchId() {
        return this.batchId;
    }

    public SliceId getSliceId() {
        return this.sliceId;
    }

    public ShuffleAddress getShuffleAddress() {
        return this.shuffleAddress;
    }
}

