/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.netty;

import com.antgroup.geaflow.shuffle.config.ShuffleConfig;
import com.antgroup.geaflow.shuffle.network.ITransportContext;
import com.antgroup.geaflow.shuffle.network.netty.NettyFrameDecoder;
import com.antgroup.geaflow.shuffle.network.netty.SliceOutputChannelHandler;
import com.antgroup.geaflow.shuffle.network.netty.SliceRequestClientHandler;
import com.antgroup.geaflow.shuffle.network.netty.SliceRequestServerHandler;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessageDecoder;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessageEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public class NettyContext
implements ITransportContext {
    private final NettyMessageEncoder messageEncoder = new NettyMessageEncoder();
    private final NettyMessageDecoder messageDecoder = new NettyMessageDecoder();
    private final ShuffleConfig config;

    public NettyContext(ShuffleConfig config) {
        this.config = config;
    }

    private ChannelHandler createFrameLengthDecoder() {
        if (this.config.enableCustomFrameDecoder()) {
            return new NettyFrameDecoder();
        }
        return new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, -4, 4);
    }

    @Override
    public ChannelHandler[] createServerChannelHandler(Channel channel) {
        SliceOutputChannelHandler queueOfPartitionQueue = new SliceOutputChannelHandler();
        SliceRequestServerHandler sliceRequestHandler = new SliceRequestServerHandler(queueOfPartitionQueue);
        return new ChannelHandler[]{this.messageEncoder, this.createFrameLengthDecoder(), this.messageDecoder, sliceRequestHandler, queueOfPartitionQueue};
    }

    @Override
    public ChannelHandler[] createClientChannelHandlers(Channel channel) {
        SliceRequestClientHandler networkClientHandler = new SliceRequestClientHandler();
        return new ChannelHandler[]{this.messageEncoder, this.createFrameLengthDecoder(), this.messageDecoder, networkClientHandler};
    }
}

