/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.api.pipeline.channel.ChannelId;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;

public class CancelRequest
extends NettyMessage {
    final ChannelId receiverId;

    public CancelRequest(ChannelId receiverId) {
        this.receiverId = (ChannelId)Preconditions.checkNotNull((Object)receiverId);
    }

    public ChannelId receiverId() {
        return this.receiverId;
    }

    public ByteBuf write(ByteBufAllocator allocator) throws Exception {
        ByteBuf result = null;
        try {
            result = CancelRequest.allocateBuffer(allocator, MessageType.CANCEL_CONNECTION.getId(), 16);
            this.receiverId.writeTo(result);
        }
        catch (Throwable t) {
            if (result != null) {
                result.release();
            }
            throw new IOException(t);
        }
        return result;
    }

    public static CancelRequest readFrom(ByteBuf buffer) throws Exception {
        return new CancelRequest(ChannelId.readFrom(buffer));
    }
}

