/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.api.pipeline.channel.ChannelId;
import com.antgroup.geaflow.shuffle.network.protocol.MessageType;
import com.antgroup.geaflow.shuffle.network.protocol.NettyMessage;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public class ErrorResponse
extends NettyMessage {
    private ChannelId channelId;
    private final Throwable cause;

    public ErrorResponse(ChannelId channelId, Throwable cause) {
        this.channelId = channelId;
        this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
    }

    public ErrorResponse(Throwable cause) {
        this.cause = (Throwable)Preconditions.checkNotNull((Object)cause);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuf write(ByteBufAllocator allocator) throws IOException {
        ByteBuf result = ErrorResponse.allocateBuffer(allocator, MessageType.ERROR_RESPONSE.getId());
        this.channelId.writeTo(result);
        try (ObjectOutputStream oos = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(result));){
            oos.writeObject(this.cause);
            result.setInt(0, result.readableBytes());
            ByteBuf byteBuf = result;
            return byteBuf;
        }
        catch (Throwable t) {
            result.release();
            if (!(t instanceof IOException)) throw new IOException(t);
            throw (IOException)t;
        }
    }

    public static ErrorResponse readFrom(ByteBuf buffer) throws Exception {
        ChannelId channelId = ChannelId.readFrom(buffer);
        try (ObjectInputStream ois = new ObjectInputStream((InputStream)new ByteBufInputStream(buffer));){
            Object obj = ois.readObject();
            if (!(obj instanceof Throwable)) {
                throw new ClassCastException("Read object expected to be of type Throwable, actual type is " + obj.getClass());
            }
            ErrorResponse errorResponse = new ErrorResponse(channelId, (Throwable)obj);
            return errorResponse;
        }
    }

    public ChannelId getChannelId() {
        return this.channelId;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public boolean isFatalError() {
        return this.channelId == null;
    }
}

