/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.network.protocol;

import com.antgroup.geaflow.shuffle.network.protocol.AbstractFileRegion;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class MemoryBytesFileRegion
extends AbstractFileRegion {
    private ByteBuffer curBuffer;

    public MemoryBytesFileRegion(byte[] buffer) {
        super(buffer.length);
        this.curBuffer = ByteBuffer.wrap(buffer);
    }

    public long transferTo(WritableByteChannel target, long position) throws IOException {
        assert (position == this.transferred);
        if (position == this.contentSize) {
            return 0L;
        }
        boolean keepGoing = true;
        long written = 0L;
        ByteBuffer currentBuffer = this.curBuffer;
        while (keepGoing) {
            while (currentBuffer.hasRemaining() && keepGoing) {
                int ioSize = Math.min(currentBuffer.remaining(), this.chunkSize);
                int originalLimit = currentBuffer.limit();
                currentBuffer.limit(currentBuffer.position() + ioSize);
                int writtenSize = target.write(currentBuffer);
                currentBuffer.limit(originalLimit);
                written += (long)writtenSize;
                if (writtenSize >= ioSize) continue;
                keepGoing = false;
            }
            if (!keepGoing) continue;
            this.curBuffer = null;
            break;
        }
        this.transferred += written;
        return written;
    }

    protected void deallocate() {
    }
}

