/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.serialize;

import com.antgroup.geaflow.common.encoder.IEncoder;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.shuffle.api.pipeline.buffer.OutBuffer;
import com.antgroup.geaflow.shuffle.serialize.AbstractMessageIterator;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncoderMessageIterator<T>
extends AbstractMessageIterator<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncoderMessageIterator.class);
    private final IEncoder<T> encoder;

    public EncoderMessageIterator(OutBuffer outBuffer, IEncoder<T> encoder) {
        super(outBuffer);
        this.encoder = encoder;
    }

    public EncoderMessageIterator(InputStream inputStream, IEncoder<T> encoder) {
        super(inputStream);
        this.encoder = encoder;
    }

    @Override
    public boolean hasNext() {
        if (this.currentValue != null) {
            return true;
        }
        try {
            if (this.inputStream.available() > 0) {
                this.currentValue = this.encoder.decode(this.inputStream);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            LOGGER.error("encoder deserialize err", (Throwable)e);
            throw new GeaflowRuntimeException(RuntimeErrors.INST.shuffleDeserializeError(e.getMessage()), (Throwable)e);
        }
    }
}

