/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.shuffle.service;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.shuffle.service.IShuffleMaster;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShuffleMasterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShuffleMasterFactory.class);

    public static IShuffleMaster getShuffleMaster(Configuration configuration) {
        Iterator<IShuffleMaster> iterator = ServiceLoader.load(IShuffleMaster.class).iterator();
        if (iterator.hasNext()) {
            IShuffleMaster shuffleMaster = iterator.next();
            shuffleMaster.init(configuration);
            return shuffleMaster;
        }
        LOGGER.warn("no shuffle master impl found");
        return null;
    }
}

