/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.data;

import com.antgroup.geaflow.utils.math.MathUtil;
import java.io.Serializable;

public class TimeRange
implements Comparable<TimeRange>,
Serializable {
    private final long start;
    private final long end;

    private TimeRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public static TimeRange of(long start, long end) {
        return new TimeRange(start, end);
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public int hashCode() {
        return MathUtil.longToIntWithBitMixing((long)(this.start + this.end));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeRange range = (TimeRange)o;
        return this.end == range.end && this.start == range.start;
    }

    public String toString() {
        return String.format("TimeRange{start=%d, end=%d}", this.start, this.end);
    }

    public boolean contain(long ts) {
        return ts >= this.start && ts < this.end;
    }

    @Override
    public int compareTo(TimeRange o) {
        return Long.compare(this.end, o.getEnd());
    }
}

