/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.state.graph.encoder.DefaultBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BytesEncoderRepo {
    private static final Map<Byte, IBytesEncoder> ENCODER_MAP = new ConcurrentHashMap<Byte, IBytesEncoder>();

    public static void register(IBytesEncoder encoder) {
        ENCODER_MAP.put(encoder.getMyMagicNumber(), encoder);
    }

    public static IBytesEncoder get(byte myMagicNumber) {
        return (IBytesEncoder)Preconditions.checkNotNull((Object)ENCODER_MAP.get(myMagicNumber), (Object)("not found encoder " + myMagicNumber));
    }

    static {
        BytesEncoderRepo.register(new DefaultBytesEncoder());
    }
}

