/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.state.graph.encoder.BaseBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class DefaultBytesEncoder
extends BaseBytesEncoder
implements IBytesEncoder {
    private final byte magicNumber = 1;

    @Override
    public byte[] combine(List<byte[]> listBytes) {
        int len = listBytes.stream().mapToInt(c -> ((byte[])c).length).sum();
        ByteBuffer bf = ByteBuffer.wrap(new byte[len + 2 * listBytes.size() + 1]);
        for (byte[] bytes : listBytes) {
            bf.put(bytes);
        }
        for (byte[] bytes : listBytes) {
            bf.putShort((short)bytes.length);
        }
        bf.put(this.combine((byte)listBytes.size(), (byte)1));
        return bf.array();
    }

    @Override
    public List<byte[]> split(byte[] bytes) {
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.position(bytes.length - 1);
        byte lastByte = bf.get();
        if (1 != this.parseMagicNumber(lastByte)) {
            return null;
        }
        int size = lastByte >> 4;
        int pos = bytes.length - 2 * size - 1;
        short[] lenArray = new short[size];
        bf.position(pos);
        for (int i = 0; i < size; ++i) {
            lenArray[i] = bf.getShort();
        }
        bf.position(0);
        ArrayList<byte[]> list = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            byte[] tmp = new byte[lenArray[i]];
            bf.get(tmp);
            list.add(tmp);
        }
        return list;
    }

    @Override
    public byte[] combine(List<byte[]> listBytes, byte[] delimiter) {
        int len = listBytes.stream().mapToInt(c -> ((byte[])c).length).sum();
        ByteBuffer bf = ByteBuffer.wrap(new byte[len + (delimiter.length + 2) * listBytes.size() + 1]);
        for (byte[] bytes : listBytes) {
            bf.put(bytes);
            bf.put(delimiter);
        }
        for (byte[] bytes : listBytes) {
            bf.putShort((short)bytes.length);
        }
        bf.put(this.combine((byte)listBytes.size(), (byte)1));
        return bf.array();
    }

    @Override
    public List<byte[]> split(byte[] bytes, byte[] delimiter) {
        ByteBuffer bf = ByteBuffer.wrap(bytes);
        bf.position(bytes.length - 1);
        byte lastByte = bf.get();
        if (1 != this.parseMagicNumber(lastByte)) {
            return null;
        }
        int size = lastByte >> 4;
        int pos = bytes.length - 2 * size - 1;
        short[] lenArray = new short[size];
        bf.position(pos);
        for (int i = 0; i < size; ++i) {
            lenArray[i] = bf.getShort();
        }
        byte[] empty = new byte[delimiter.length];
        bf.position(0);
        ArrayList<byte[]> list = new ArrayList<byte[]>(size);
        for (int i = 0; i < size; ++i) {
            byte[] tmp = new byte[lenArray[i]];
            bf.get(tmp);
            list.add(tmp);
            bf.get(empty);
        }
        return list;
    }

    @Override
    public byte getMyMagicNumber() {
        return 1;
    }
}

