/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.edge.EdgeDirection;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.meta.GraphFiledName;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public enum EdgeAtom {
    SRC_ID{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return edge.getSrcId();
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getKeyType().serialize(edge.getSrcId());
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            edge.setSrcId(value);
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            edge.setSrcId(graphDataSchema.getKeyType().deserialize(value));
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.SRC_ID;
        }
    }
    ,
    DST_ID{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return edge.getTargetId();
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getKeyType().serialize(edge.getTargetId());
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            edge.setTargetId(value);
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            edge.setTargetId(graphDataSchema.getKeyType().deserialize(value));
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.DST_ID;
        }
    }
    ,
    TIME{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getEdgeMeta().getGraphFieldSerializer().getValue(edge, GraphFiledName.TIME);
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return Longs.toByteArray((long)((Long)this.getValue(edge, graphDataSchema)));
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getEdgeMeta().getGraphFieldSerializer().setValue(edge, GraphFiledName.TIME, value);
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(edge, Longs.fromByteArray((byte[])value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.TIME;
        }
    }
    ,
    DESC_TIME{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return Long.MAX_VALUE - (Long)TIME.getValue(edge, graphDataSchema);
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return Longs.toByteArray((long)((Long)this.getValue(edge, graphDataSchema)));
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getEdgeMeta().getGraphFieldSerializer().setValue(edge, GraphFiledName.TIME, (Object)(Long.MAX_VALUE - (Long)value));
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(edge, Longs.fromByteArray((byte[])value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.TIME;
        }
    }
    ,
    DIRECTION{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return edge.getDirect();
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            byte[] byArray;
            if (edge.getDirect() == EdgeDirection.IN) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 0;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 1;
            }
            return byArray;
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            edge.setDirect((EdgeDirection)value);
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            if (value[0] == 0) {
                edge.setDirect(EdgeDirection.IN);
            } else {
                edge.setDirect(EdgeDirection.OUT);
            }
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.DIRECTION;
        }
    }
    ,
    LABEL{

        @Override
        public <K, EV> Object getValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getEdgeMeta().getGraphFieldSerializer().getValue(edge, GraphFiledName.LABEL);
        }

        @Override
        public <K, EV> byte[] getBinaryValue(IEdge<K, EV> edge, GraphDataSchema graphDataSchema) {
            return this.getValue(edge, graphDataSchema).toString().getBytes();
        }

        @Override
        public <K, EV> void setValue(IEdge<K, EV> edge, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getEdgeMeta().getGraphFieldSerializer().setValue(edge, GraphFiledName.LABEL, value);
        }

        @Override
        public <K, EV> void setBinaryValue(IEdge<K, EV> edge, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(edge, new String(value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.LABEL;
        }
    };

    public static final Map<GraphFiledName, EdgeAtom> EDGE_ATOM_MAP;

    public abstract <K, EV> Object getValue(IEdge<K, EV> var1, GraphDataSchema var2);

    public abstract <K, EV> byte[] getBinaryValue(IEdge<K, EV> var1, GraphDataSchema var2);

    public abstract <K, EV> void setValue(IEdge<K, EV> var1, Object var2, GraphDataSchema var3);

    public abstract <K, EV> void setBinaryValue(IEdge<K, EV> var1, byte[] var2, GraphDataSchema var3);

    public abstract GraphFiledName getGraphFieldName();

    public static EdgeAtom getEnum(String value) {
        for (EdgeAtom v : EdgeAtom.values()) {
            if (!v.name().equalsIgnoreCase(value)) continue;
            return v;
        }
        return null;
    }

    public Comparator<IEdge> getComparator() {
        switch (this) {
            case TIME: {
                return Comparator.comparingLong(o -> ((IGraphElementWithTimeField)o).getTime());
            }
            case DESC_TIME: {
                return Collections.reverseOrder(Comparator.comparingLong(o -> ((IGraphElementWithTimeField)o).getTime()));
            }
            case DIRECTION: {
                return (o1, o2) -> Integer.compare(o2.getDirect().ordinal(), o1.getDirect().ordinal());
            }
            case DST_ID: {
                return (o1, o2) -> ((Comparable)o1.getTargetId()).compareTo(o2.getTargetId());
            }
            case SRC_ID: {
                return (o1, o2) -> ((Comparable)o1.getSrcId()).compareTo(o2.getTargetId());
            }
            case LABEL: {
                return Comparator.comparing(o -> ((IGraphElementWithLabelField)o).getLabel());
            }
        }
        throw new RuntimeException("no comparator");
    }

    static {
        EDGE_ATOM_MAP = ImmutableMap.of((Object)GraphFiledName.SRC_ID, (Object)((Object)SRC_ID), (Object)GraphFiledName.DST_ID, (Object)((Object)DST_ID), (Object)GraphFiledName.TIME, (Object)((Object)TIME), (Object)GraphFiledName.DIRECTION, (Object)((Object)DIRECTION), (Object)GraphFiledName.LABEL, (Object)((Object)LABEL));
    }
}

