/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.graph.encoder.EdgeKVEncoderWithoutValue;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import com.antgroup.geaflow.state.schema.GraphDataSchema;

public class EdgeKVEncoder<K, EV>
extends EdgeKVEncoderWithoutValue<K, EV> {
    public EdgeKVEncoder(GraphDataSchema graphDataSchema, IBytesEncoder bytesEncoder) {
        super(graphDataSchema, bytesEncoder);
    }

    @Override
    public Tuple<byte[], byte[]> format(IEdge<K, EV> edge) {
        Tuple<byte[], byte[]> res = super.format(edge);
        res.f1 = this.graphDataSchema.getEdgePropertySerFun().apply(edge.getValue());
        return res;
    }

    @Override
    public IEdge<K, EV> getEdge(byte[] key, byte[] value) {
        IEdge edge = super.getEdge(key, value);
        return edge.withValue(this.graphDataSchema.getEdgePropertyDeFun().apply(value));
    }
}

