/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.config.Configuration;
import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Collectors;

public class GraphKVEncoderFactory {
    private static final char EDGE_ORDER_SPLITTER = ',';

    public static <K, VV, EV> IGraphKVEncoder<K, VV, EV> build(Configuration config, GraphDataSchema schema) {
        String clazz = config.getString(StateConfigKeys.STATE_KV_ENCODER_CLASS);
        String edgeOrder = config.getString(StateConfigKeys.STATE_KV_ENCODER_EDGE_ORDER);
        if (edgeOrder != null && edgeOrder.length() > 0) {
            List<EdgeAtom> list = Splitter.on((char)',').splitToList((CharSequence)edgeOrder).stream().map(c -> EdgeAtom.getEnum(c.trim())).collect(Collectors.toList());
            schema.setEdgeAtoms(list);
        }
        try {
            IGraphKVEncoder encoder = (IGraphKVEncoder)Class.forName(clazz).newInstance();
            encoder.init(schema);
            return encoder;
        }
        catch (Exception e) {
            throw new GeaflowRuntimeException(RuntimeErrors.INST.runError(e.getMessage()), (Throwable)e);
        }
    }
}

