/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.graph.encoder.BytesEncoderRepo;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.VertexAtom;
import com.antgroup.geaflow.state.graph.encoder.VertexKVEncoderWithoutValue;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import java.util.ArrayList;
import java.util.List;

public class VertexKVEncoder<K, VV>
extends VertexKVEncoderWithoutValue<K, VV> {
    public VertexKVEncoder(GraphDataSchema graphDataSchema, IBytesEncoder bytesEncoder) {
        super(graphDataSchema, bytesEncoder);
    }

    @Override
    public Tuple<byte[], byte[]> format(IVertex<K, VV> vertex) {
        byte[] a = this.keyType.serialize(vertex.getId());
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (int i = 1; i < this.vertexSchema.size(); ++i) {
            bytes.add(((VertexAtom)((Object)this.vertexSchema.get(i))).getBinaryValue(vertex, this.graphDataSchema));
        }
        bytes.add(this.graphDataSchema.getVertexPropertySerFun().apply(vertex.getValue()));
        return new Tuple((Object)a, (Object)this.bytesEncoder.combine(bytes));
    }

    @Override
    public IVertex<K, VV> getVertex(byte[] key, byte[] value) {
        int i;
        IVertex vertex = this.graphDataSchema.getVertexConsFun().get();
        vertex.setId(this.keyType.deserialize(key));
        List<byte[]> values = this.bytesEncoder.split(value);
        if (values == null) {
            IBytesEncoder encoder = BytesEncoderRepo.get(this.bytesEncoder.parseMagicNumber(key[value.length - 1]));
            values = encoder.split(value);
        }
        for (i = 1; i < this.vertexSchema.size(); ++i) {
            ((VertexAtom)((Object)this.vertexSchema.get(i))).setBinaryValue(vertex, values.get(i - 1), this.graphDataSchema);
        }
        return vertex.withValue(this.graphDataSchema.getVertexPropertyDeFun().apply(values.get(i - 1)));
    }
}

