/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Predicate;

public class IteratorWithFilter<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private final Predicate<T> predicate;
    private T nextValue;

    public IteratorWithFilter(Iterator<T> iterator, Predicate<T> predicate) {
        this.iterator = iterator;
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    @Override
    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (!this.predicate.test(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public T next() {
        return this.nextValue;
    }
}

