/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import java.util.Iterator;
import java.util.function.Function;

public class IteratorWithFlatFn<T, R>
implements Iterator<R> {
    private final Iterator<T> iterator;
    private final Function<T, Iterator<R>> fn;
    private Iterator<R> inIt;

    public IteratorWithFlatFn(Iterator<T> iterator, Function<T, Iterator<R>> function) {
        this.iterator = iterator;
        this.fn = function;
    }

    @Override
    public boolean hasNext() {
        if (this.inIt != null && this.inIt.hasNext()) {
            return true;
        }
        while (this.iterator.hasNext()) {
            this.inIt = this.fn.apply(this.iterator.next());
            if (!this.inIt.hasNext()) continue;
            return true;
        }
        return false;
    }

    @Override
    public R next() {
        return this.inIt.next();
    }
}

