/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorWithFnThenFilter<T, R>
implements Iterator<R> {
    protected final Iterator<T> iterator;
    protected final Function<T, R> fn;
    private final Predicate<R> predicate;
    private R nextValue;

    public IteratorWithFnThenFilter(Iterator<T> iterator, Function<T, R> function, Predicate<R> predicate) {
        this.iterator = iterator;
        this.fn = function;
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    @Override
    public boolean hasNext() {
        while (this.iterator != null && this.iterator.hasNext()) {
            this.nextValue = this.fn.apply(this.iterator.next());
            if (!this.predicate.test(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public R next() {
        return this.nextValue;
    }
}

