/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import java.util.Arrays;
import java.util.Iterator;

public class MultiIterator<T>
implements Iterator<T> {
    private final Iterator<? extends Iterator<? extends T>> iterators;
    private Iterator<? extends T> currIterator;
    private T nextValue;

    public MultiIterator(Iterator<? extends Iterator<? extends T>> iterators) {
        this.iterators = iterators;
        if (iterators.hasNext()) {
            this.currIterator = iterators.next();
        }
    }

    public MultiIterator(Iterator<? extends T> ... iteratorCandidates) {
        this.iterators = Arrays.asList(iteratorCandidates).iterator();
        if (this.iterators.hasNext()) {
            this.currIterator = this.iterators.next();
        }
    }

    @Override
    public boolean hasNext() {
        if (this.currIterator == null) {
            return false;
        }
        if (!this.currIterator.hasNext()) {
            do {
                if (!this.iterators.hasNext()) {
                    return false;
                }
                this.currIterator = this.iterators.next();
            } while (!this.currIterator.hasNext());
        }
        this.nextValue = this.currIterator.next();
        return true;
    }

    @Override
    public T next() {
        return this.nextValue;
    }
}

