/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import java.util.Iterator;

public class StandardIterator<T>
implements Iterator<T> {
    private final Iterator<T> iterator;
    private boolean nextCalled;
    private boolean hasNextValue;
    private T nextValue;

    public StandardIterator(Iterator<T> iterator) {
        this.iterator = iterator;
        this.innerNext();
    }

    private void innerNext() {
        this.hasNextValue = this.iterator.hasNext();
        this.nextValue = this.hasNextValue ? this.iterator.next() : null;
        this.nextCalled = false;
    }

    @Override
    public boolean hasNext() {
        if (this.nextCalled) {
            this.innerNext();
        }
        return this.hasNextValue;
    }

    @Override
    public T next() {
        if (this.nextValue != null) {
            this.nextCalled = true;
            T next = this.nextValue;
            this.nextValue = null;
            return next;
        }
        return null;
    }
}

