/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IVertexFilter;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class VertexLabelFilter<K, VV>
implements IVertexFilter<K, VV> {
    private Set<String> labels;

    public VertexLabelFilter(Collection<String> list) {
        this.labels = Sets.newHashSet(list);
    }

    public VertexLabelFilter(String ... labels) {
        this.labels = Sets.newHashSet((Object[])labels);
    }

    public static <K, VV> VertexLabelFilter<K, VV> instance(String ... labels) {
        return new VertexLabelFilter<K, VV>(labels);
    }

    @Override
    public boolean filter(IVertex<K, VV> value) {
        return this.labels.contains(((IGraphElementWithLabelField)value).getLabel());
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.VERTEX_LABEL;
    }

    public String toString() {
        return String.format("\"%s(%s)\"", this.getFilterType().toString(), Joiner.on((char)',').join(this.labels));
    }
}

