/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.TimeRange;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IVertexFilter;

public class VertexTsFilter<K, VV>
implements IVertexFilter<K, VV> {
    private final TimeRange timeRange;

    public VertexTsFilter(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public static <K, VV> VertexTsFilter<K, VV> instance(long start, long end) {
        return new VertexTsFilter<K, VV>(TimeRange.of(start, end));
    }

    @Override
    public boolean filter(IVertex<K, VV> value) {
        return this.timeRange.contain(((IGraphElementWithTimeField)value).getTime());
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.VERTEX_TS;
    }

    public String toString() {
        return String.format("\"%s[%d,%d)\"", this.getFilterType().toString(), this.timeRange.getStart(), this.timeRange.getEnd());
    }
}

