/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.inner.BaseComposeGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import java.util.List;

public class AndGraphFilter
extends BaseComposeGraphFilter {
    public AndGraphFilter(List<IGraphFilter> childrenFilters) {
        super(childrenFilters);
    }

    @Override
    public IGraphFilter and(IGraphFilter other) {
        switch (other.getFilterType()) {
            case EMPTY: {
                return this;
            }
            case AND: {
                this.childrenFilters.addAll(((AndGraphFilter)other).getFilterList());
                return this;
            }
        }
        this.childrenFilters.add(other);
        return this;
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        for (IGraphFilter filter : this.childrenFilters) {
            if (filter.filterEdge(edge)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filterVertex(IVertex vertex) {
        for (IGraphFilter filter : this.childrenFilters) {
            if (filter.filterVertex(vertex)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean filterOneDegreeGraph(OneDegreeGraph oneDegreeGraph) {
        for (IGraphFilter filter : this.childrenFilters) {
            if (filter.filterOneDegreeGraph(oneDegreeGraph)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AndGraphFilter clone() {
        return new AndGraphFilter(this.cloneFilterList());
    }

    @Override
    public boolean contains(FilterType type) {
        if (type == FilterType.AND) {
            return true;
        }
        for (IGraphFilter filter : this.childrenFilters) {
            if (!filter.contains(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IGraphFilter retrieve(FilterType type) {
        if (type == FilterType.AND) {
            return this;
        }
        for (IGraphFilter filter : this.childrenFilters) {
            if (!filter.contains(type)) continue;
            return filter.retrieve(type);
        }
        return null;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.AND;
    }
}

