/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.BaseGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseComposeGraphFilter
extends BaseGraphFilter {
    protected List<IGraphFilter> childrenFilters;

    public BaseComposeGraphFilter(List<IGraphFilter> childrenFilters) {
        this.childrenFilters = childrenFilters;
    }

    @Override
    public DataType dateType() {
        return DataType.OTHER;
    }

    @Override
    public boolean dropAllRemaining() {
        for (IGraphFilter filter : this.childrenFilters) {
            if (filter.dropAllRemaining()) continue;
            return false;
        }
        return true;
    }

    public List<IGraphFilter> getFilterList() {
        return this.childrenFilters;
    }

    public List<IGraphFilter> cloneFilterList() {
        ArrayList<IGraphFilter> copyList = new ArrayList<IGraphFilter>(this.childrenFilters.size());
        this.childrenFilters.forEach(c -> copyList.add(c.clone()));
        return copyList;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"").append(this.getFilterType().name()).append("\":[");
        if (this.childrenFilters != null && this.childrenFilters.size() > 0) {
            int size = this.childrenFilters.size();
            int index = 0;
            for (IFilter iFilter : this.childrenFilters) {
                sb.append(iFilter.toString());
                if (index < size - 1) {
                    sb.append(",");
                }
                ++index;
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }
}

