/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.pushdown.filter.AndFilter;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.OrFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.AndGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.BaseGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.EmptyGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.LimitFilterBuilder;
import com.antgroup.geaflow.state.pushdown.filter.inner.OrGraphFilter;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import java.util.List;
import java.util.stream.Collectors;

public class GraphFilter
extends BaseGraphFilter {
    private final DataType dataType;
    private IFilter filter;

    private GraphFilter(IFilter filter) {
        this.filter = filter;
        this.dataType = filter.dateType();
    }

    public static IGraphFilter of(IFilter filter) {
        if (filter instanceof IGraphFilter) {
            return (IGraphFilter)filter;
        }
        switch (filter.getFilterType()) {
            case EMPTY: {
                return EmptyGraphFilter.of();
            }
            case AND: {
                List<IGraphFilter> childrenFilters = ((AndFilter)filter).getFilters().stream().map(GraphFilter::of).collect(Collectors.toList());
                return new AndGraphFilter(childrenFilters);
            }
            case OR: {
                List<IGraphFilter> childrenFilters = ((OrFilter)filter).getFilters().stream().map(GraphFilter::of).collect(Collectors.toList());
                return new OrGraphFilter(childrenFilters);
            }
        }
        return new GraphFilter(filter);
    }

    public static IGraphFilter of(IGraphFilter graphFilter, IEdgeLimit limit) {
        return limit == null ? graphFilter : LimitFilterBuilder.build(graphFilter, limit);
    }

    public static IGraphFilter of(IFilter filter, IEdgeLimit limit) {
        IGraphFilter graphFilter = GraphFilter.of(filter);
        return GraphFilter.of(graphFilter, limit);
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        if (this.dataType == DataType.E) {
            return this.filter.filter(edge);
        }
        return true;
    }

    @Override
    public boolean filterVertex(IVertex vertex) {
        if (this.dataType == DataType.V) {
            return this.filter.filter(vertex);
        }
        return true;
    }

    @Override
    public boolean filterOneDegreeGraph(OneDegreeGraph oneDegreeGraph) {
        if (this.dataType == DataType.VE) {
            return this.filter.filter(oneDegreeGraph);
        }
        return true;
    }

    @Override
    public DataType dateType() {
        return this.filter.dateType();
    }

    @Override
    public FilterType getFilterType() {
        return this.filter.getFilterType();
    }
}

