/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.model.graph.edge.EdgeDirection;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.LimitFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.OrGraphFilter;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import java.util.List;

public class SingleLimitFilter
extends LimitFilter {
    private List<IGraphFilter> filters;
    private final long[] outCounters;
    private final long[] inCounters;
    private long needHitMaxVersion;
    private long hitMaxVersion;

    SingleLimitFilter(IGraphFilter filter, IEdgeLimit limit) {
        super(filter, limit);
        this.filters = ((OrGraphFilter)filter).childrenFilters;
        this.outCounters = new long[this.filters.size()];
        this.inCounters = new long[this.filters.size()];
        this.needHitMaxVersion = (long)this.filters.size() * (this.inCounter + this.outCounter);
        if (this.needHitMaxVersion < 0L) {
            this.needHitMaxVersion = Long.MAX_VALUE;
        }
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        boolean keep = false;
        int i = 0;
        for (IGraphFilter filter : this.filters) {
            if (filter.filterEdge(edge)) {
                if (edge.getDirect() == EdgeDirection.OUT && this.outCounters[i] < this.outCounter) {
                    int n = i;
                    this.outCounters[n] = this.outCounters[n] + 1L;
                    ++this.hitMaxVersion;
                    keep = true;
                }
                if (edge.getDirect() == EdgeDirection.IN && this.inCounters[i] < this.inCounter) {
                    int n = i;
                    this.inCounters[n] = this.inCounters[n] + 1L;
                    ++this.hitMaxVersion;
                    keep = true;
                }
            }
            ++i;
        }
        return keep;
    }

    @Override
    public boolean dropAllRemaining() {
        return this.hitMaxVersion >= this.needHitMaxVersion;
    }

    @Override
    public String toString() {
        return String.format("%s(%d, %d)", this.getClass().getSimpleName(), this.inCounter, this.outCounter);
    }
}

