/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.inner;

import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.state.data.TimeRange;
import com.antgroup.geaflow.state.pushdown.filter.AndFilter;
import com.antgroup.geaflow.state.pushdown.filter.EdgeLabelFilter;
import com.antgroup.geaflow.state.pushdown.filter.EdgeTsFilter;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.OrFilter;
import com.antgroup.geaflow.state.pushdown.filter.VertexLabelFilter;
import com.antgroup.geaflow.state.pushdown.filter.VertexTsFilter;
import com.antgroup.geaflow.state.pushdown.inner.FilterPlanWithData;
import com.antgroup.geaflow.state.pushdown.inner.PushDownPb;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class FilterGenerator {
    public static FilterPlanWithData getFilterPlanWithData(IFilter filter) {
        PushDownPb.FilterNode plan = FilterGenerator.getFilterPlan(filter);
        PushDownPb.FilterNode data = FilterGenerator.getFilterData(filter);
        return new FilterPlanWithData(plan, data);
    }

    private static PushDownPb.FilterNode getFilterPlan(IFilter filter) {
        FilterType filterType = filter.getFilterType();
        switch (filterType) {
            case AND: {
                return FilterGenerator.getLogicalPlan(filterType, ((AndFilter)filter).getFilters());
            }
            case OR: {
                return FilterGenerator.getLogicalPlan(filterType, ((OrFilter)filter).getFilters());
            }
            case VERTEX_LABEL: 
            case EDGE_LABEL: 
            case VERTEX_TS: 
            case EDGE_TS: 
            case IN_EDGE: 
            case OUT_EDGE: 
            case VERTEX_VALUE_DROP: 
            case EDGE_VALUE_DROP: 
            case VERTEX_MUST_CONTAIN: {
                return FilterGenerator.getNormalPlan(filterType);
            }
        }
        throw new GeaflowRuntimeException("not support user defined filter " + (Object)((Object)filter.getFilterType()));
    }

    private static PushDownPb.FilterNode getLogicalPlan(FilterType filterType, List<IFilter> filters) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).addAllFilters(filters.stream().sorted(Comparator.comparingInt(o -> o.getFilterType().ordinal())).map(FilterGenerator::getFilterPlan).collect(Collectors.toList())).build();
    }

    private static PushDownPb.FilterNode getNormalPlan(FilterType filterType) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).build();
    }

    private static PushDownPb.FilterNode getFilterData(IFilter filter) {
        FilterType filterType = filter.getFilterType();
        switch (filterType) {
            case AND: {
                return FilterGenerator.getLogicalFilterData(filterType, ((AndFilter)filter).getFilters());
            }
            case OR: {
                return FilterGenerator.getLogicalFilterData(filterType, ((OrFilter)filter).getFilters());
            }
            case VERTEX_LABEL: {
                return FilterGenerator.getStringFilterData(filterType, ((VertexLabelFilter)filter).getLabels());
            }
            case EDGE_LABEL: {
                return FilterGenerator.getStringFilterData(filterType, ((EdgeLabelFilter)filter).getLabels());
            }
            case VERTEX_TS: {
                TimeRange range = ((VertexTsFilter)filter).getTimeRange();
                List<Long> longs = Arrays.asList(range.getStart(), range.getEnd());
                return FilterGenerator.getLongFilterData(filterType, longs);
            }
            case EDGE_TS: {
                TimeRange range = ((EdgeTsFilter)filter).getTimeRange();
                List<Long> longs = Arrays.asList(range.getStart(), range.getEnd());
                return FilterGenerator.getLongFilterData(filterType, longs);
            }
            case IN_EDGE: 
            case OUT_EDGE: 
            case VERTEX_VALUE_DROP: 
            case EDGE_VALUE_DROP: 
            case VERTEX_MUST_CONTAIN: {
                return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).build();
            }
        }
        throw new GeaflowRuntimeException("not support user defined filter " + (Object)((Object)filter.getFilterType()));
    }

    private static PushDownPb.FilterNode getLogicalFilterData(FilterType filterType, List<IFilter> filters) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).addAllFilters(filters.stream().sorted(Comparator.comparingInt(o -> o.getFilterType().ordinal())).map(FilterGenerator::getFilterData).collect(Collectors.toList())).build();
    }

    private static PushDownPb.FilterNode getStringFilterData(FilterType filterType, Collection<String> strs) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).setStrContent(PushDownPb.StringList.newBuilder().addAllStr(strs).build()).build();
    }

    private static PushDownPb.FilterNode getLongFilterData(FilterType filterType, Collection<Long> longs) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).setLongContent(PushDownPb.LongList.newBuilder().addAllLong(longs).build()).build();
    }

    private static PushDownPb.FilterNode getIntFilterData(FilterType filterType, Collection<Integer> ints) {
        return PushDownPb.FilterNode.newBuilder().setFilterOrdinal(filterType.ordinal()).setIntContent(PushDownPb.IntList.newBuilder().addAllInt(ints).build()).build();
    }
}

