/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.serializer;

import com.antgroup.geaflow.common.serialize.ISerializer;
import com.antgroup.geaflow.common.serialize.SerializerFactory;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.common.type.Types;
import com.antgroup.geaflow.state.serializer.IKVSerializer;
import java.util.function.Function;

public class DefaultKVSerializer<K, V>
implements IKVSerializer<K, V> {
    private Function<K, byte[]> keySerializer;
    private Function<V, byte[]> valueSerializer;
    private Function<byte[], K> keyDeserializer;
    private Function<byte[], V> valueDeserializer;

    public DefaultKVSerializer(Class<K> keyClazz, Class<V> valueClazz) {
        IType keyType = Types.getType(keyClazz);
        IType valueType = Types.getType(valueClazz);
        ISerializer serializer = SerializerFactory.getKryoSerializer();
        this.keySerializer = keyType == null ? arg_0 -> ((ISerializer)serializer).serialize(arg_0) : arg_0 -> ((IType)keyType).serialize(arg_0);
        Function<byte[], Object> function = this.keyDeserializer = keyType == null ? c -> serializer.deserialize(c) : arg_0 -> ((IType)keyType).deserialize(arg_0);
        this.valueSerializer = valueType == null ? arg_0 -> ((ISerializer)serializer).serialize(arg_0) : arg_0 -> ((IType)valueType).serialize(arg_0);
        this.valueDeserializer = valueType == null ? c -> serializer.deserialize(c) : arg_0 -> ((IType)valueType).deserialize(arg_0);
    }

    @Override
    public byte[] serializeKey(K key) {
        return this.keySerializer.apply(key);
    }

    @Override
    public K deserializeKey(byte[] array) {
        return this.keyDeserializer.apply(array);
    }

    @Override
    public byte[] serializeValue(V value) {
        return this.valueSerializer.apply(value);
    }

    @Override
    public V deserializeValue(byte[] valueArray) {
        return this.valueDeserializer.apply(valueArray);
    }
}

