/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.config.keys.StateConfigKeys;
import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.graph.encoder.BytesEncoderRepo;
import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.IEdgeKVEncoder;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;

public class EdgeKVEncoderWithoutValue<K, EV>
implements IEdgeKVEncoder<K, EV> {
    protected static final byte[] EMPTY_BYTES = new byte[0];
    protected final GraphDataSchema graphDataSchema;
    protected final List<EdgeAtom> edgeSchema;
    protected final IType keyType;
    protected final IBytesEncoder bytesEncoder;

    public EdgeKVEncoderWithoutValue(GraphDataSchema graphDataSchema, IBytesEncoder bytesEncoder) {
        this.graphDataSchema = graphDataSchema;
        this.edgeSchema = graphDataSchema.getEdgeAtoms();
        this.keyType = graphDataSchema.getKeyType();
        this.bytesEncoder = bytesEncoder;
    }

    @Override
    public byte[] getScanBytes(K key) {
        return Bytes.concat((byte[][])new byte[][]{this.keyType.serialize(key), StateConfigKeys.DELIMITER});
    }

    @Override
    public Tuple<byte[], byte[]> format(IEdge<K, EV> edge) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(this.edgeSchema.size());
        for (int i = 0; i < this.edgeSchema.size(); ++i) {
            list.add(this.edgeSchema.get(i).getBinaryValue(edge, this.graphDataSchema));
        }
        byte[] a = this.bytesEncoder.combine(list, StateConfigKeys.DELIMITER);
        return new Tuple((Object)a, (Object)EMPTY_BYTES);
    }

    @Override
    public IEdge<K, EV> getEdge(byte[] key, byte[] value) {
        IEdge edge = this.graphDataSchema.getEdgeConsFun().get();
        List<byte[]> values = this.bytesEncoder.split(key, StateConfigKeys.DELIMITER);
        if (values == null) {
            IBytesEncoder encoder = BytesEncoderRepo.get(this.bytesEncoder.parseMagicNumber(key[key.length - 1]));
            values = encoder.split(key, StateConfigKeys.DELIMITER);
        }
        for (int i = 0; i < this.edgeSchema.size(); ++i) {
            this.edgeSchema.get(i).setBinaryValue(edge, values.get(i), this.graphDataSchema);
        }
        return edge;
    }

    @Override
    public IBytesEncoder getBytesEncoder() {
        return this.bytesEncoder;
    }
}

