/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.state.graph.encoder.DefaultBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.EdgeKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.EdgeKVEncoderWithoutValue;
import com.antgroup.geaflow.state.graph.encoder.IEdgeKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.IGraphKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.IVertexKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.VertexKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.VertexKVEncoderWithoutValue;
import com.antgroup.geaflow.state.schema.GraphDataSchema;

public class GraphKVEncoder<K, VV, EV>
implements IGraphKVEncoder<K, VV, EV> {
    private GraphDataSchema graphDataSchema;
    private IType keyType;
    private IVertexKVEncoder<K, VV> vertexKVEncoder;
    private IEdgeKVEncoder<K, EV> edgeKVEncoder;

    @Override
    public void init(GraphDataSchema graphDataSchema) {
        this.graphDataSchema = graphDataSchema;
        this.keyType = graphDataSchema.getKeyType();
        DefaultBytesEncoder bytesEncoder = new DefaultBytesEncoder();
        this.vertexKVEncoder = this.graphDataSchema.isEmptyVertexProperty() ? new VertexKVEncoderWithoutValue(graphDataSchema, bytesEncoder) : new VertexKVEncoder(graphDataSchema, bytesEncoder);
        this.edgeKVEncoder = this.graphDataSchema.isEmptyEdgeProperty() ? new EdgeKVEncoderWithoutValue(graphDataSchema, bytesEncoder) : new EdgeKVEncoder(graphDataSchema, bytesEncoder);
    }

    @Override
    public IType<K> getKeyType() {
        return this.keyType;
    }

    @Override
    public IVertexKVEncoder<K, VV> getVertexEncoder() {
        return this.vertexKVEncoder;
    }

    @Override
    public IEdgeKVEncoder<K, EV> getEdgeEncoder() {
        return this.edgeKVEncoder;
    }
}

