/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.model.graph.meta.GraphFiledName;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Longs;
import java.util.Map;

public enum VertexAtom {
    ID{

        @Override
        public <K, VV> Object getValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return vertex.getId();
        }

        @Override
        public <K, VV> byte[] getBinaryValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getKeyType().serialize(vertex.getId());
        }

        @Override
        public <K, VV> void setValue(IVertex<K, VV> vertex, Object value, GraphDataSchema graphDataSchema) {
            vertex.setId(value);
        }

        @Override
        public <K, VV> void setBinaryValue(IVertex<K, VV> vertex, byte[] value, GraphDataSchema graphDataSchema) {
            vertex.setId(graphDataSchema.getKeyType().deserialize(value));
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.ID;
        }
    }
    ,
    TIME{

        @Override
        public <K, VV> Object getValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getVertexMeta().getGraphFieldSerializer().getValue(vertex, GraphFiledName.TIME);
        }

        @Override
        public <K, VV> byte[] getBinaryValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return Longs.toByteArray((long)((Long)this.getValue(vertex, graphDataSchema)));
        }

        @Override
        public <K, VV> void setValue(IVertex<K, VV> vertex, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getVertexMeta().getGraphFieldSerializer().setValue(vertex, GraphFiledName.TIME, value);
        }

        @Override
        public <K, VV> void setBinaryValue(IVertex<K, VV> vertex, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(vertex, Longs.fromByteArray((byte[])value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.TIME;
        }
    }
    ,
    DESC_TIME{

        @Override
        public <K, VV> Object getValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return Long.MAX_VALUE - (Long)TIME.getValue(vertex, graphDataSchema);
        }

        @Override
        public <K, VV> byte[] getBinaryValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return Longs.toByteArray((long)((Long)this.getValue(vertex, graphDataSchema)));
        }

        @Override
        public <K, VV> void setValue(IVertex<K, VV> vertex, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getEdgeMeta().getGraphFieldSerializer().setValue(vertex, GraphFiledName.TIME, (Object)(Long.MAX_VALUE - (Long)value));
        }

        @Override
        public <K, VV> void setBinaryValue(IVertex<K, VV> vertex, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(vertex, Longs.fromByteArray((byte[])value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.TIME;
        }
    }
    ,
    LABEL{

        @Override
        public <K, VV> Object getValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return graphDataSchema.getVertexMeta().getGraphFieldSerializer().getValue(vertex, GraphFiledName.LABEL);
        }

        @Override
        public <K, VV> byte[] getBinaryValue(IVertex<K, VV> vertex, GraphDataSchema graphDataSchema) {
            return this.getValue(vertex, graphDataSchema).toString().getBytes();
        }

        @Override
        public <K, VV> void setValue(IVertex<K, VV> vertex, Object value, GraphDataSchema graphDataSchema) {
            graphDataSchema.getVertexMeta().getGraphFieldSerializer().setValue(vertex, GraphFiledName.LABEL, value);
        }

        @Override
        public <K, VV> void setBinaryValue(IVertex<K, VV> vertex, byte[] value, GraphDataSchema graphDataSchema) {
            this.setValue(vertex, new String(value), graphDataSchema);
        }

        @Override
        public GraphFiledName getGraphFieldName() {
            return GraphFiledName.TIME;
        }
    };

    public static final Map<GraphFiledName, VertexAtom> VERTEX_ATOM_MAP;

    public abstract <K, VV> Object getValue(IVertex<K, VV> var1, GraphDataSchema var2);

    public abstract <K, VV> byte[] getBinaryValue(IVertex<K, VV> var1, GraphDataSchema var2);

    public abstract <K, VV> void setValue(IVertex<K, VV> var1, Object var2, GraphDataSchema var3);

    public abstract <K, VV> void setBinaryValue(IVertex<K, VV> var1, byte[] var2, GraphDataSchema var3);

    public abstract GraphFiledName getGraphFieldName();

    public static VertexAtom getEnum(String value) {
        for (VertexAtom v : VertexAtom.values()) {
            if (!v.name().equalsIgnoreCase(value)) continue;
            return v;
        }
        return null;
    }

    static {
        VERTEX_ATOM_MAP = ImmutableMap.of((Object)GraphFiledName.ID, (Object)((Object)ID), (Object)GraphFiledName.TIME, (Object)((Object)TIME), (Object)GraphFiledName.LABEL, (Object)((Object)LABEL));
    }
}

