/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.graph.encoder;

import com.antgroup.geaflow.common.tuple.Tuple;
import com.antgroup.geaflow.common.type.IType;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.graph.encoder.BytesEncoderRepo;
import com.antgroup.geaflow.state.graph.encoder.IBytesEncoder;
import com.antgroup.geaflow.state.graph.encoder.IVertexKVEncoder;
import com.antgroup.geaflow.state.graph.encoder.VertexAtom;
import com.antgroup.geaflow.state.schema.GraphDataSchema;
import java.util.ArrayList;
import java.util.List;

public class VertexKVEncoderWithoutValue<K, VV>
implements IVertexKVEncoder<K, VV> {
    protected final GraphDataSchema graphDataSchema;
    protected final List<VertexAtom> vertexSchema;
    protected final IType keyType;
    protected final IBytesEncoder bytesEncoder;

    public VertexKVEncoderWithoutValue(GraphDataSchema graphDataSchema, IBytesEncoder bytesEncoder) {
        this.graphDataSchema = graphDataSchema;
        this.vertexSchema = graphDataSchema.getVertexAtoms();
        this.keyType = graphDataSchema.getKeyType();
        this.bytesEncoder = bytesEncoder;
    }

    @Override
    public Tuple<byte[], byte[]> format(IVertex<K, VV> vertex) {
        byte[] a = this.keyType.serialize(vertex.getId());
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (int i = 1; i < this.vertexSchema.size(); ++i) {
            bytes.add(this.vertexSchema.get(i).getBinaryValue(vertex, this.graphDataSchema));
        }
        return new Tuple((Object)a, (Object)this.bytesEncoder.combine(bytes));
    }

    @Override
    public IVertex<K, VV> getVertex(byte[] key, byte[] value) {
        IVertex vertex = this.graphDataSchema.getVertexConsFun().get();
        vertex.setId(this.keyType.deserialize(key));
        List<byte[]> values = this.bytesEncoder.split(value);
        if (values == null) {
            IBytesEncoder encoder = BytesEncoderRepo.get(this.bytesEncoder.parseMagicNumber(key[value.length - 1]));
            values = encoder.split(value);
        }
        for (int i = 1; i < this.vertexSchema.size(); ++i) {
            this.vertexSchema.get(i).setBinaryValue(vertex, values.get(i - 1), this.graphDataSchema);
        }
        return vertex;
    }

    @Override
    public K getVertexID(byte[] key) {
        return (K)this.keyType.deserialize(key);
    }

    @Override
    public IBytesEncoder getBytesEncoder() {
        return this.bytesEncoder;
    }
}

