/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.state.iterator.BaseCloseableIterator;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorWithFilterThenFn<T, R>
extends BaseCloseableIterator<T, R> {
    private final Predicate<T> predicate;
    private final Function<T, R> function;
    private T nextValue;

    public IteratorWithFilterThenFn(CloseableIterator<T> iterator, Predicate<T> predicate, Function<T, R> function) {
        super(iterator);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
        this.function = function;
    }

    public IteratorWithFilterThenFn(Iterator<T> iterator, Predicate<T> predicate, Function<T, R> function) {
        super(iterator);
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
        this.function = function;
    }

    public boolean hasNext() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (!this.predicate.test(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    public R next() {
        return this.function.apply(this.nextValue);
    }
}

