/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.state.iterator.BaseCloseableIterator;
import java.util.Iterator;
import java.util.function.Function;

public class IteratorWithFlatFn<T, R>
extends BaseCloseableIterator<T, R> {
    private final Function<T, Iterator<R>> fn;
    private Iterator<R> inIt;

    public IteratorWithFlatFn(CloseableIterator<T> iterator, Function<T, Iterator<R>> function) {
        super(iterator);
        this.fn = function;
    }

    public IteratorWithFlatFn(Iterator<T> iterator, Function<T, Iterator<R>> function) {
        super(iterator);
        this.fn = function;
    }

    public boolean hasNext() {
        if (this.inIt != null && this.inIt.hasNext()) {
            return true;
        }
        while (this.iterator.hasNext()) {
            this.inIt = this.fn.apply(this.iterator.next());
            if (!this.inIt.hasNext()) continue;
            return true;
        }
        return false;
    }

    public R next() {
        return this.inIt.next();
    }
}

