/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import com.antgroup.geaflow.state.iterator.BaseCloseableIterator;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorWithFnThenFilter<T, R>
extends BaseCloseableIterator<T, R> {
    protected final Function<T, R> fn;
    private final Predicate<R> predicate;
    private R nextValue;

    public IteratorWithFnThenFilter(CloseableIterator<T> iterator, Function<T, R> function, Predicate<R> predicate) {
        super(iterator);
        this.fn = function;
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    public IteratorWithFnThenFilter(Iterator<T> iterator, Function<T, R> function, Predicate<R> predicate) {
        super(iterator);
        this.fn = function;
        this.predicate = (Predicate)Preconditions.checkNotNull(predicate);
    }

    public boolean hasNext() {
        while (this.iterator != null && this.iterator.hasNext()) {
            this.nextValue = this.fn.apply(this.iterator.next());
            if (!this.predicate.test(this.nextValue)) continue;
            return true;
        }
        return false;
    }

    public R next() {
        return this.nextValue;
    }
}

