/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.iterator;

import com.antgroup.geaflow.common.iterator.CloseableIterator;
import java.util.Arrays;
import java.util.Iterator;

public class MultiIterator<T>
implements CloseableIterator<T> {
    private final Iterator<? extends CloseableIterator<? extends T>> iterators;
    private CloseableIterator<? extends T> currIterator;
    private T nextValue;

    public MultiIterator(Iterator<? extends CloseableIterator<? extends T>> iterators) {
        this.iterators = iterators;
        if (iterators.hasNext()) {
            this.currIterator = iterators.next();
        }
    }

    public MultiIterator(CloseableIterator<? extends T> ... iteratorCandidates) {
        this.iterators = Arrays.asList(iteratorCandidates).iterator();
        if (this.iterators.hasNext()) {
            this.currIterator = this.iterators.next();
        }
    }

    public boolean hasNext() {
        if (this.currIterator == null) {
            return false;
        }
        if (!this.currIterator.hasNext()) {
            this.currIterator.close();
            do {
                if (!this.iterators.hasNext()) {
                    return false;
                }
                this.currIterator = this.iterators.next();
            } while (!this.currIterator.hasNext());
        }
        this.nextValue = this.currIterator.next();
        return true;
    }

    public T next() {
        return this.nextValue;
    }

    public void close() {
        if (this.currIterator != null) {
            this.currIterator.close();
        }
        while (this.iterators.hasNext()) {
            this.currIterator = this.iterators.next();
            this.currIterator.close();
        }
    }
}

