/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown;

import com.antgroup.geaflow.state.graph.encoder.EdgeAtom;
import com.antgroup.geaflow.state.pushdown.IStatePushDown;
import com.antgroup.geaflow.state.pushdown.PushDownType;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.EmptyGraphFilter;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;
import com.antgroup.geaflow.state.pushdown.project.IProjector;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StatePushDown<K, T, R>
implements IStatePushDown {
    protected IProjector<T, R> projector;
    protected IFilter filter = EmptyGraphFilter.of();
    protected Map<K, IFilter> filters;
    protected IEdgeLimit edgeLimit;
    protected List<EdgeAtom> orderFields;
    protected PushDownType pushdownType = PushDownType.NORMAL;

    protected StatePushDown() {
    }

    public static StatePushDown of() {
        return new StatePushDown();
    }

    public StatePushDown withFilters(Map<K, IFilter> filters) {
        this.filters = filters;
        return this;
    }

    public StatePushDown withFilter(IFilter filter) {
        this.filter = filter;
        return this;
    }

    public StatePushDown withEdgeLimit(IEdgeLimit edgeLimit) {
        this.edgeLimit = edgeLimit;
        return this;
    }

    public StatePushDown withOrderField(EdgeAtom orderField) {
        if (orderField != null) {
            this.orderFields = Collections.singletonList(orderField);
        }
        return this;
    }

    public StatePushDown withOrderFields(List<EdgeAtom> orderFields) {
        this.orderFields = orderFields;
        return this;
    }

    public StatePushDown<K, T, R> withProjector(IProjector<T, R> projector) {
        this.projector = projector;
        this.pushdownType = PushDownType.PROJECT;
        return this;
    }

    @Override
    public IProjector<T, R> getProjector() {
        return this.projector;
    }

    @Override
    public IFilter getFilter() {
        return this.filter;
    }

    public Map<K, IFilter> getFilters() {
        return this.filters;
    }

    @Override
    public IEdgeLimit getEdgeLimit() {
        return this.edgeLimit;
    }

    @Override
    public List<EdgeAtom> getOrderFields() {
        return this.orderFields;
    }

    @Override
    public PushDownType getType() {
        return this.pushdownType;
    }

    @Override
    public boolean isEmpty() {
        boolean filterEmpty = this.filter == null || this.filter.getFilterType() == FilterType.EMPTY;
        boolean filtersEmpty = this.filters == null || this.filters.isEmpty();
        boolean orderEmpty = this.orderFields == null || this.orderFields.isEmpty();
        return filterEmpty && filtersEmpty && orderEmpty && this.edgeLimit == null && this.projector == null;
    }
}

