/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public abstract class BaseLogicFilter
implements IFilter {
    protected List<IFilter> filters = new ArrayList<IFilter>();
    protected BitSet rootBitSet = new BitSet();
    protected DataType dateType;

    public BaseLogicFilter(List<IFilter> inputs) {
        Preconditions.checkArgument((inputs != null && inputs.size() > 0 ? 1 : 0) != 0);
        for (IFilter filter : inputs) {
            this.handleFilter(filter);
        }
    }

    public BaseLogicFilter(IFilter ... inputs) {
        Preconditions.checkNotNull((Object)inputs);
        for (IFilter filter : inputs) {
            this.handleFilter(filter);
        }
    }

    public boolean filter(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataType dateType() {
        return this.dateType;
    }

    public List<IFilter> getFilters() {
        return this.filters;
    }

    public BitSet getRootBitSet() {
        return this.rootBitSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{\"").append((Object)this.getFilterType()).append("\":[");
        if (this.filters != null && this.filters.size() > 0) {
            int size = this.filters.size();
            int index = 0;
            for (IFilter filter : this.filters) {
                sb.append(filter.toString());
                if (index < size - 1) {
                    sb.append(",");
                }
                ++index;
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }

    private void handleFilter(IFilter filter) {
        if (filter.getFilterType() == FilterType.EMPTY) {
            return;
        }
        this.sanityCheck(filter);
        if (filter.getFilterType() == this.getFilterType()) {
            this.filters.addAll(((BaseLogicFilter)filter).filters);
        } else {
            this.filters.add(filter);
        }
    }

    abstract void sanityCheck(IFilter var1);
}

