/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.model.graph.IGraphElementWithLabelField;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IEdgeFilter;
import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;

public class EdgeLabelFilter<K, EV>
implements IEdgeFilter<K, EV> {
    private Set<String> labels;

    public EdgeLabelFilter(Collection<String> list) {
        this.labels = Sets.newHashSet(list);
    }

    public EdgeLabelFilter(String ... labels) {
        this.labels = Sets.newHashSet((Object[])labels);
    }

    public static <K, EV> EdgeLabelFilter<K, EV> instance(String ... labels) {
        return new EdgeLabelFilter<K, EV>(labels);
    }

    @Override
    public boolean filter(IEdge<K, EV> value) {
        return this.labels.contains(((IGraphElementWithLabelField)value).getLabel());
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.EDGE_LABEL;
    }

    public String toString() {
        return String.format("\"%s(%s)\"", this.getFilterType().name(), Joiner.on((char)',').join(this.labels));
    }
}

