/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.model.graph.IGraphElementWithTimeField;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.state.data.TimeRange;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IEdgeFilter;

public class EdgeTsFilter<K, EV>
implements IEdgeFilter<K, EV> {
    private final TimeRange timeRange;

    public EdgeTsFilter(TimeRange timeRange) {
        this.timeRange = timeRange;
    }

    public static <K, EV> EdgeTsFilter<K, EV> instance(long start, long end) {
        return new EdgeTsFilter<K, EV>(TimeRange.of(start, end));
    }

    @Override
    public boolean filter(IEdge<K, EV> value) {
        return this.timeRange.contain(((IGraphElementWithTimeField)value).getTime());
    }

    public TimeRange getTimeRange() {
        return this.timeRange;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.EDGE_TS;
    }

    public String toString() {
        return String.format("\"%s[%d,%d)\"", this.getFilterType().name(), this.timeRange.getStart(), this.timeRange.getEnd());
    }
}

