/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter;

import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.pushdown.filter.BaseLogicFilter;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.IFilter;
import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.List;

public class OrFilter
extends BaseLogicFilter {
    private static final BitSet EMPTY_BIT_SET = new BitSet();
    private boolean singleLimit;

    public OrFilter(List<IFilter> inputs) {
        super(inputs);
    }

    public OrFilter(IFilter ... inputs) {
        super(inputs);
    }

    @Override
    void sanityCheck(IFilter filter) {
        FilterType filterType = filter.getFilterType();
        DataType filterDataType = filter.dateType();
        Preconditions.checkArgument((!filterType.isRootFilter() ? 1 : 0) != 0, (String)"filter illegal %s", (Object)((Object)filterType));
        if (this.dateType == null) {
            this.dateType = filterDataType;
        } else {
            Preconditions.checkArgument((this.dateType == filterDataType ? 1 : 0) != 0, (String)"mix vertex filter and edge filter in OR list, %s, %s", (Object)((Object)this.dateType), (Object)((Object)filterDataType));
        }
        BitSet filterRootBitSet = EMPTY_BIT_SET;
        if (filterType == FilterType.OR || filter.getFilterType() == FilterType.AND) {
            filterRootBitSet = ((BaseLogicFilter)filter).rootBitSet;
        }
        if (this.filters.size() == 0 && filterRootBitSet != EMPTY_BIT_SET) {
            this.rootBitSet = filterRootBitSet;
        } else if (this.filters.size() > 0) {
            Preconditions.checkArgument((boolean)this.rootBitSet.equals(filterRootBitSet));
        }
    }

    public OrFilter singleLimit() {
        this.singleLimit = true;
        return this;
    }

    public boolean isSingleLimit() {
        return this.singleLimit;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.OR;
    }
}

