/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.inner.AndGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.OrGraphFilter;
import java.util.ArrayList;

public abstract class BaseGraphFilter
implements IGraphFilter {
    @Override
    public boolean filter(Object value) {
        switch (this.dateType()) {
            case V: {
                return this.filterVertex((IVertex)value);
            }
            case E: {
                return this.filterEdge((IEdge)value);
            }
            case VE: {
                return this.filterOneDegreeGraph((OneDegreeGraph)value);
            }
        }
        throw new GeaflowRuntimeException(RuntimeErrors.INST.runError("not support " + (Object)((Object)this.dateType())));
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        return true;
    }

    @Override
    public boolean filterVertex(IVertex vertex) {
        return true;
    }

    @Override
    public boolean filterOneDegreeGraph(OneDegreeGraph oneDegreeGraph) {
        return true;
    }

    @Override
    public boolean dropAllRemaining() {
        return false;
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.OTHER;
    }

    @Override
    public IGraphFilter and(IGraphFilter other) {
        ArrayList<IGraphFilter> list = new ArrayList<IGraphFilter>();
        list.add(this);
        if (other.getFilterType() == FilterType.AND) {
            list.addAll(((AndGraphFilter)other).getFilterList());
        } else {
            list.add(other);
        }
        return new AndGraphFilter(list);
    }

    @Override
    public IGraphFilter or(IGraphFilter other) {
        ArrayList<IGraphFilter> list = new ArrayList<IGraphFilter>();
        list.add(this);
        if (other.getFilterType() == FilterType.OR) {
            list.addAll(((OrGraphFilter)other).getFilterList());
        } else {
            list.add(other);
        }
        return new OrGraphFilter(list);
    }

    @Override
    public boolean contains(FilterType type) {
        return type == this.getFilterType();
    }

    @Override
    public IGraphFilter retrieve(FilterType type) {
        return this.contains(type) ? this : null;
    }

    public String toString() {
        return this.getFilterType().name();
    }

    @Override
    public IGraphFilter clone() {
        return this;
    }
}

