/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.common.errorcode.RuntimeErrors;
import com.antgroup.geaflow.common.exception.GeaflowRuntimeException;
import com.antgroup.geaflow.model.graph.edge.EdgeDirection;
import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.DataType;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.inner.BaseGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import com.antgroup.geaflow.state.pushdown.limit.IEdgeLimit;

public class LimitFilter
extends BaseGraphFilter {
    protected long inCounter;
    protected long outCounter;
    protected IGraphFilter filter;

    LimitFilter(IGraphFilter filter, IEdgeLimit limit) {
        this.filter = filter;
        this.inCounter = limit.inEdgeLimit();
        this.outCounter = limit.outEdgeLimit();
    }

    @Override
    public DataType dateType() {
        return DataType.OTHER;
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        if (!this.filter.filterEdge(edge)) {
            return false;
        }
        if (edge.getDirect() == EdgeDirection.OUT && this.outCounter-- > 0L) {
            return true;
        }
        return edge.getDirect() == EdgeDirection.IN && this.inCounter-- > 0L;
    }

    @Override
    public boolean filterVertex(IVertex vertex) {
        return this.filter.filterVertex(vertex);
    }

    @Override
    public boolean filterOneDegreeGraph(OneDegreeGraph oneDegreeGraph) {
        return this.filter.filterOneDegreeGraph(oneDegreeGraph);
    }

    @Override
    public boolean dropAllRemaining() {
        return this.outCounter <= 0L && this.inCounter <= 0L || this.filter.dropAllRemaining();
    }

    @Override
    public String toString() {
        return String.format("Limit(%d, %d)", this.inCounter, this.outCounter);
    }

    @Override
    public FilterType getFilterType() {
        return this.filter.getFilterType();
    }

    @Override
    public IGraphFilter and(IGraphFilter other) {
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    @Override
    public IGraphFilter or(IGraphFilter other) {
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }

    @Override
    public boolean contains(FilterType type) {
        return this.filter.contains(type);
    }

    @Override
    public IGraphFilter retrieve(FilterType type) {
        return this.filter.retrieve(type);
    }

    @Override
    public IGraphFilter clone() {
        throw new GeaflowRuntimeException(RuntimeErrors.INST.unsupportedError());
    }
}

