/*
 * Decompiled with CFR 0.152.
 */
package com.antgroup.geaflow.state.pushdown.filter.inner;

import com.antgroup.geaflow.model.graph.edge.IEdge;
import com.antgroup.geaflow.model.graph.vertex.IVertex;
import com.antgroup.geaflow.state.data.OneDegreeGraph;
import com.antgroup.geaflow.state.pushdown.filter.FilterType;
import com.antgroup.geaflow.state.pushdown.filter.inner.BaseComposeGraphFilter;
import com.antgroup.geaflow.state.pushdown.filter.inner.IGraphFilter;
import java.util.List;

public class OrGraphFilter
extends BaseComposeGraphFilter {
    public OrGraphFilter(List<IGraphFilter> childrenFilters) {
        super(childrenFilters);
    }

    @Override
    public IGraphFilter or(IGraphFilter filter) {
        if (filter.getFilterType() == FilterType.OR) {
            this.childrenFilters.addAll(((OrGraphFilter)filter).getFilterList());
            return this;
        }
        if (filter.getFilterType() == FilterType.EMPTY) {
            return this;
        }
        this.childrenFilters.add(filter);
        return this;
    }

    @Override
    public boolean filterEdge(IEdge edge) {
        if (this.childrenFilters.isEmpty()) {
            return true;
        }
        for (IGraphFilter filter : this.childrenFilters) {
            if (!filter.filterEdge(edge)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterVertex(IVertex vertex) {
        if (this.childrenFilters.isEmpty()) {
            return true;
        }
        for (IGraphFilter filter : this.childrenFilters) {
            if (!filter.filterVertex(vertex)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterOneDegreeGraph(OneDegreeGraph oneDegreeGraph) {
        if (this.childrenFilters.isEmpty()) {
            return true;
        }
        for (IGraphFilter filter : this.childrenFilters) {
            if (!filter.filterOneDegreeGraph(oneDegreeGraph)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(FilterType type) {
        return false;
    }

    @Override
    public IGraphFilter retrieve(FilterType type) {
        return null;
    }

    @Override
    public OrGraphFilter clone() {
        return new OrGraphFilter(this.cloneFilterList());
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.OR;
    }
}

